<?php
/**
 * Benz Service Configuration
 * تنظیمات سرویس Benz
 */

// ============================================================================
// Google Gemini API
// ============================================================================

define('GEMINI_API_URL', 'https://generativelanguage.googleapis.com/v1beta/models');
define('GEMINI_API_KEY', 'YOUR_GEMINI_API_KEY_HERE'); // تغییر دهید!
define('GEMINI_DEFAULT_MODEL', 'gemini-2.0-flash');

// ============================================================================
// Doppy API
// ============================================================================

define('DOPPY_API_URL', 'https://assistant.doppy.ir/create');

// ============================================================================
// Benz Service Settings
// ============================================================================

define('BENZ_API_VERSION', '1.0.0');
define('BENZ_LOG_FILE', __DIR__ . '/logs/benz.log');
define('BENZ_CACHE_DIR', __DIR__ . '/cache/');
define('BENZ_MAX_LOG_SIZE', 10 * 1024 * 1024); // 10 MB

// ============================================================================
// API Keys
// ============================================================================

$API_KEYS = [
    'your-secret-api-key-here' => [
        'name' => 'Doppy Content Generator',
        'created' => date('Y-m-d'),
        'active' => true,
        'rate_limit' => 1000,
        'domains' => ['*']
    ],
    // می‌توانید کلیدهای بیشتری اضافه کنید
];

// ============================================================================
// Rate Limiting
// ============================================================================

define('RATE_LIMIT_REQUESTS', 100); // درخواست‌های در هر دقیقه
define('RATE_LIMIT_WINDOW', 60); // پنجرة زمانی (ثانیه)

// ============================================================================
// Timeouts
// ============================================================================

define('CURL_TIMEOUT', 60);
define('GEMINI_TIMEOUT', 60);
define('DOPPY_TIMEOUT', 60);

// ============================================================================
// Error Handling
// ============================================================================

define('DEBUG_MODE', false); // غیرفعال برای Production!
define('LOG_ERRORS', true);
define('LOG_REQUEST_BODY', false); // حساس - نگاه داشتن API Key!

// ============================================================================
// Security
// ============================================================================

define('ALLOWED_ORIGINS', '*'); // تمام منابع
define('VERIFY_SSL', false); // برای SSL خود: true

// ============================================================================
// توابع کمکی
// ============================================================================

function get_api_key_from_env() {
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        preg_match('/Bearer\s+(.+)/i', $_SERVER['HTTP_AUTHORIZATION'], $matches);
        return $matches[1] ?? '';
    }
    return '';
}

function is_valid_api_key($key) {
    global $API_KEYS;
    return isset($API_KEYS[$key]) && $API_KEYS[$key]['active'];
}

function log_request($action, $data = []) {
    if (!LOG_ERRORS) return;
    
    $log_entry = [
        'timestamp' => date('Y-m-d H:i:s'),
        'action' => $action,
        'ip' => $_SERVER['REMOTE_ADDR'] ?? '',
        'data' => $data
    ];
    
    @file_put_contents(BENZ_LOG_FILE, json_encode($log_entry) . PHP_EOL, FILE_APPEND);
}

// ایجاد پوشه‌ها
@mkdir(dirname(BENZ_LOG_FILE), 0755, true);
@mkdir(BENZ_CACHE_DIR, 0755, true);
