# 🔐 Benz Service - Proxy Server برای Doppy

راهنمای نصب سرویس Benz برای `pr.benzinyab.com`

---

## 📋 فهرست

1. [ساختار فایل‌ها](#ساختار)
2. [نصب و راه‌اندازی](#نصب)
3. [تنظیمات](#تنظیمات)
4. [استفاده](#استفاده)
5. [امنیت](#امنیت)
6. [حل مشکلات](#حل-مشکلات)

---

## 📁 ساختار فایل‌ها

```
pr.benzinyab.com/
├── api/
│   └── index.php              (API اصلی)
├── admin/
│   └── index.html             (Panel مدیریتی)
├── cache/                      (فایل‌های موقتی)
├── logs/                       (فایل‌های لاگ)
├── config.php                 (تنظیمات)
├── .htaccess                  (Routing و Security)
└── README.md                  (این فایل)
```

---

## 🚀 نصب و راه‌اندازی

### مرحلة 1: آپلود فایل‌ها

```bash
# SSH یا File Manager
cd /home/username/public_html/pr.benzinyab.com

# آپلود فایل‌های زیر:
- api/index.php
- admin/index.html
- config.php
- .htaccess
```

### مرحلة 2: ایجاد پوشه‌ها

```bash
mkdir -p cache
mkdir -p logs
chmod 755 cache
chmod 755 logs
chmod 644 .htaccess
```

### مرحلة 3: تنظیم API Key Gemini

```bash
# ویرایش config.php:
nano config.php
```

تغییر این خط:
```php
define('GEMINI_API_KEY', 'YOUR_GEMINI_API_KEY_HERE');
```

به:
```php
define('GEMINI_API_KEY', 'YOUR_ACTUAL_API_KEY');
```

دریافت از: https://makersuite.google.com/app/apikey

---

## ⚙️ تنظیمات

### config.php

#### Gemini Settings:
```php
define('GEMINI_API_KEY', 'sk-...');          // API Key
define('GEMINI_DEFAULT_MODEL', 'gemini-2.0-flash');
```

#### API Keys:
```php
$API_KEYS = [
    'your-secret-api-key-here' => [
        'name' => 'Doppy Content Generator',
        'active' => true,
    ]
];
```

**تغییر `your-secret-api-key-here` به کلید خود!**

---

## 🔑 ایجاد API Key

### برای Doppy WordPress Plugin:

```bash
# Key جدید را بسازید:
your-unique-api-key-12345

# در config.php اضافه کنید:
'your-unique-api-key-12345' => [
    'name' => 'My Doppy Client',
    'active' => true,
]
```

---

## 📊 استفاده

### Test API:

```bash
curl https://pr.benzinyab.com/api/doppy/test
```

**نتیجة متوقع:**
```json
{
    "success": true,
    "version": "1.0.0",
    "services": ["gemini", "doppy", "image_download"]
}
```

### تولید محتوا:

```bash
curl -X POST https://pr.benzinyab.com/api/doppy/generate/content \
  -H "Authorization: Bearer your-secret-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{
    "keywords": "هوش مصنوعی",
    "model": "gemini-2.0-flash",
    "temperature": 0.7
  }'
```

### تولید تصویر:

```bash
curl -X POST https://pr.benzinyab.com/api/doppy/generate/image \
  -H "Authorization: Bearer your-secret-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{
    "prompt": "Professional AI illustration"
  }'
```

---

## 🔒 امنیت

### فایل‌های حساس:

```bash
# محدود کردن دسترسی:
chmod 600 config.php
chmod 700 logs
chmod 700 cache
```

### .htaccess:

```bash
# جلوگیری از دسترسی مستقیم:
<FilesMatch "config\.php|\.env">
    Deny from all
</FilesMatch>
```

### Headers:

```
X-Content-Type-Options: nosniff
X-Frame-Options: DENY
X-XSS-Protection: 1; mode=block
```

---

## 📋 Admin Panel

### دسترسی:

```
https://pr.benzinyab.com/admin/
```

### ویژگی‌ها:

- 📊 مشاهدة آمار
- ✅ بررسی وضعیت سرویس‌ها
- 🔑 مدیریت API Keys
- 📈 مشاهدة لاگ‌ها
- ⚙️ تنظیمات

---

## 🐛 حل مشکلات

### مشکل 1: "API Key نامعتبر"

```
❌ error: Unauthorized - Invalid API Key

✅ حل:
1. config.php را بررسی کنید
2. API Key را اصلاح کنید
3. در Doppy Settings درست وارد کنید
```

### مشکل 2: "Gemini Error"

```
❌ Gemini API Error: invalid_api_key

✅ حل:
1. https://makersuite.google.com/app/apikey را باز کنید
2. API Key جدید دریافت کنید
3. config.php را اپدیت کنید
```

### مشکل 3: "Timeout"

```
❌ cURL timeout

✅ حل:
1. config.php را باز کنید
2. CURL_TIMEOUT را افزایش دهید
   define('CURL_TIMEOUT', 120);
```

### مشکل 4: "Permission Denied"

```
❌ Cannot write to logs

✅ حل:
chmod 755 logs
chmod 755 cache
```

---

## 📊 Logs و Monitoring

### مشاهدة لاگ‌ها:

```bash
tail -f logs/benz.log
```

### Log Format:

```json
{
    "timestamp": "2026-02-24 12:34:56",
    "action": "generate_content",
    "ip": "192.168.1.1",
    "data": {
        "keywords": "AI"
    }
}
```

---

## 📞 نکات مهم

```
⚠️ تغییر دادن:
- GEMINI_API_KEY
- API Keys
- DEBUG_MODE

❌ بگذار اینجا:
- DOPPY_API_URL (ثابت باشد)
- Routing Logic
- Security Headers
```

---

## ✅ Checklist نصب

```
□ فایل‌ها آپلود شدند
□ پوشه‌ها ایجاد شدند
□ config.php تنظیم شد
□ API Key Gemini اضافه شد
□ .htaccess درست است
□ /api/doppy/test کار می‌کند
□ Admin Panel باز می‌شود
```

---

## 🎉 نتیجة نهایی

```
✅ Benz Service نصب شده
✅ تمام Endpoints آماده
✅ Admin Panel فعال
✅ Ready برای Doppy Plugin
```

---

**Benz Service v1.0.0**  
**برای: pr.benzinyab.com**  
**وضعیت: آماده برای استفاده**
